#ifndef MICEXPR_H
#define MICEXPR_H

#include "Param.h"
#include "ParamList.h"
#include "Expr.h"


class MicExpr : public ErrMsg, public Expr 
{
public:
    MicExpr(ParamList* plist) : _plist(plist) { 
	_parser_debug = getenv("MIC_PARSER_DEBUG") ? true : false;
    }

    bool eval_all();

private:
    virtual int  ResolveName(char *name, u_int64_t *val);
    virtual void Error(char *message) { errmsg(message); }

    ParamList* _plist;
    bool       _parser_debug;

};

#endif // MICEXPR_H
